/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.template;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.client.capture.Capture;
import io.github.mortuusars.exposure.client.capture.palettizer.Palettizer;
import io.github.mortuusars.exposure.client.capture.saving.ExposureUploader;
import io.github.mortuusars.exposure.client.capture.template.CaptureTemplate;
import io.github.mortuusars.exposure.client.image.modifier.ImageModifier;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.util.cycles.task.EmptyTask;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.CaptureProperties;
import io.github.mortuusars.exposure.world.camera.capture.ProjectionInfo;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import net.minecraft.class_1297;
import net.minecraft.class_6880;
import org.slf4j.Logger;

public class PathCaptureTemplate
implements CaptureTemplate {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public Task<?> createTask(CaptureProperties data) {
        if (data.exposureId().isEmpty()) {
            LOGGER.error("Failed to create capture task: exposure id cannot be empty. '{}'", (Object)data);
            return new EmptyTask();
        }
        int entityId = data.cameraHolderEntityId().orElse(Minecrft.player().method_5628());
        class_1297 class_12972 = Minecrft.level().method_8469(entityId);
        if (!(class_12972 instanceof CameraHolder)) {
            LOGGER.error("Failed to create capture task: camera holder cannot be obtained. '{}'", (Object)data);
            return new EmptyTask();
        }
        CameraHolder cameraHolder = (CameraHolder)class_12972;
        if (data.projection().isEmpty()) {
            LOGGER.error("Cannot load: projecting info is missing. {}", (Object)data);
            return new EmptyTask();
        }
        ProjectionInfo projectionInfo = data.projection().get();
        String path = projectionInfo.path();
        ExposureType filmType = data.filmType();
        int frameSize = data.frameSize().orElse(Config.Server.DEFAULT_FRAME_SIZE.getAsInt());
        ShutterSpeed shutterSpeed = data.shutterSpeed().orElse(ShutterSpeed.DEFAULT);
        class_6880<ColorPalette> palette = data.getColorPalette(Minecrft.registryAccess());
        return Capture.of(Capture.path(path)).logErrorAndGetResult(LOGGER).thenAsync(ImageModifier.chain(ImageModifier.Crop.SQUARE_CENTER, ImageModifier.Resize.to(frameSize), ImageModifier.brightness(shutterSpeed), ImageModifier.optional(filmType == ExposureType.BLACK_AND_WHITE, data.singleChannel().map(ImageModifier::singleChannelBlackAndWhite).orElse(ImageModifier.BLACK_AND_WHITE)))).thenAsync(Palettizer.fromProjectionMode(projectionInfo.mode()).palettizeAndClose((ColorPalette)palette.comp_349())).thenAsync(this.convertToExposureData(palette, this.createExposureTag(cameraHolder.getPlayerExecutingExposure(), data, true))).acceptAsync(image -> ExposureUploader.upload(data.exposureId(), image)).onError(err -> LOGGER.error(err.technical().getString()));
    }
}

